/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.util.nullness;

import com.tterrag.registrate.fabric.Lazy;
import com.tterrag.registrate.util.nullness.NonnullType;
import com.tterrag.registrate.util.nullness.NullableType;
import java.util.Objects;
import java.util.function.Supplier;

@FunctionalInterface
public interface NonNullSupplier<@NonnullType T>
extends Supplier<T> {
    public static <T> NonNullSupplier<T> of(Supplier<@NullableType T> sup) {
        return NonNullSupplier.of(sup, () -> "Unexpected null value from supplier");
    }

    public static <T> NonNullSupplier<T> of(Supplier<@NullableType T> sup, NonNullSupplier<String> errorMsg) {
        return () -> {
            Object res = sup.get();
            Objects.requireNonNull(res, errorMsg);
            return res;
        };
    }

    default public NonNullSupplier<T> lazy() {
        return NonNullSupplier.lazy(this);
    }

    public static <T> NonNullSupplier<T> lazy(Supplier<@NonnullType T> sup) {
        return new Lazy<T>(sup)::get;
    }
}

